/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

class VWOpenItemInfo {
    public static final int TYPE_LSP = 0;
    public static final int TYPE_SP = 1;
    public static final String PROTOCOL_HTTP = "http://";
    public static final String PROTOCOL_HTTPS = "https://";
    private String m_baseURL = null;
    private String m_lspUrlTemplate = null;
    private String m_spUrlTemplate = null;
    private int m_nWebAppId = -1;

    public VWOpenItemInfo(int nWebAppId) {
        this.m_nWebAppId = nWebAppId;
    }

    public String getBaseURL() {
        return this.m_baseURL;
    }

    public void setBaseURL(String baseURL) {
        if (baseURL != null && baseURL.length() > 0) {
            this.m_baseURL = baseURL.trim();
            if (!this.m_baseURL.startsWith(PROTOCOL_HTTP) && !this.m_baseURL.startsWith(PROTOCOL_HTTPS)) {
                this.m_baseURL = PROTOCOL_HTTP + this.m_baseURL;
            }
            if (this.m_baseURL.endsWith("/")) {
                this.m_baseURL = this.m_baseURL.substring(0, this.m_baseURL.length() - 1);
            }
        }
    }

    public String getLspUrlTemplate() {
        return this.m_lspUrlTemplate;
    }

    public void setLspUrlTemplate(String urlTemplate) {
        this.m_lspUrlTemplate = urlTemplate.trim();
    }

    public String getSpUrlTemplate() {
        return this.m_spUrlTemplate;
    }

    public void setSpUrlTemplate(String urlTemplate) {
        this.m_spUrlTemplate = urlTemplate.trim();
    }

    public int getWebAppId() {
        return this.m_nWebAppId;
    }

    public boolean isValid(int nType) {
        if (this.m_baseURL == null || this.m_baseURL.length() <= PROTOCOL_HTTP.length()) {
            return false;
        }
        if (nType == 0 ? this.m_lspUrlTemplate == null || this.m_lspUrlTemplate.length() == 0 : this.m_spUrlTemplate == null || this.m_spUrlTemplate.length() == 0) {
            return false;
        }
        return this.m_nWebAppId >= 0 && this.m_nWebAppId <= 999;
    }
}

